	clear all
	close all
	% Digital Filters Example 2.2
	% Requirements for the digital lowpass filter
	fc = 2000;
	fs = 2500;
	fsample = 10000;
	wcT = 2*pi*fc/fsample;
	wsT = 2*pi*fs/fsample;
	Amax = 1;
	Amin = 20;
	
	% Requirements for the analog prototype lowpass filter
	T = 1/fsample;
	wac = (2/T)*tan(wcT/2);
	was = (2/T)*tan(wsT/2);
	
	% Design of the analog prototype lowpass filter (Cauer)
	[Na, Wan] = ellipord(wac, was, Amax, Amin, 's');
	[Za, Pa, Ga] = ellipap(Na, Amax, Amin);
	Za = Za*wac;
	Pa = Pa*wac;
	Ga = Ga*wac^(length(Pa)-length(Za));
	
	% Transformation of the analog prototype filter into the digital filter
	%	[Z, P, G] = bilinear(Za, Pa, Ga, 1/T)
	[G, Z, P] = PZ_2_PZ_Z(Ga, Za, Pa, T)
	
	% Computation of frequency, magnitude, and group delay responses
	wT = linspace(0, pi, 5000);
	[N, D] = zp2tf(Z, P, G);
	[H, wT] = freqz(N, D, wT);
	magdB = 20*log10(abs(H)+10^-10);
	gd = PZ_2_TG_Z(G, Z, P, wT);	
	P = cplxpair(P);
	m = 1;
	for n = 1:2:length(P)-1
		a1(m) = 2*real(P(n));
		a2(m) = -abs(P(n))^2;
		m = m+1;
	end
	if mod(length(P),2) == 1
		a1(m) = P(length(P));
		a2(m) = 0;
	end
	Z = cplxpair(Z);
	m = 1;
	for n = 1:2:length(Z)-1
		b0(m) = 1;
		b1(m) = -2*real(Z(n));
		b2(m) = abs(Z(n))^2;
		m = m+1;
	end
	if mod(length(Z),2) == 1
		b0(m) = 1;
		b1(m) = -Z(length(Z));
		b2(m) = 0;
	end
	% Perform the filtering
	u1 = zeros(1,m);
	u2 = zeros(1,m);
	xin = 1;	% Impulse
	y = G*xin;
	s=zeros(1,51);
	for n = 1:50
		for i = 1:length(a2)
			u0 = y + a1(i)*u1(i) + a2(i)*u2(i);
			y = u0 + b1(i)*u1(i) + b2(i)*u2(i); 	
			u2(i) = u1(i);
			u1(i) = u0;	
		end
		h(n) = y;
		s(n+1)=s(n)+y;
		y = 0;
	end
	s(1)=[];
	figure(1)
	subplot('position', [0.1 0.4 0.86 0.5]);
	PLOT_IMPULSE_RESPONSE_Z(h)
	
	figure(2)
	subplot('position', [0.1 0.4 0.86 0.5]);
	PLOT_STEP_RESPONSE_Z(s)
	
	figure(3)
	H(abs(H) < 10^-4) = 10^-4;
	Att = -20*log10(abs(H));
	Amaxplot = 60;
	Att(abs(Att) > Amaxplot) = Amaxplot;
	Att(Att < 0) = 0;
	subplot('position', [0.1 0.4 0.86 0.5]);
	PLOT_ATT_Z(wT, Att, pi, 60)
	zoom on
	
	figure(4)
	subplot('position', [0.1 0.4 0.86 0.5]);
	PLOT_MAG_Z_dB(wT, H, pi, 60, 'H')
	
	figure(5)
	subplot('position', [0.12 0.4 0.86 0.5]);
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	
	PLOT_TG_Z(wT, Taug, 0, 10)
	
	figure(6)
	subplot('position', [0.1 0.4 0.86 0.5]);
	Phase = PZ_2_PHASE_Z(G, Z, P, wT);
	PLOT_PHASE_Z(wT, Phase, -pi, pi), zoom on
	
%	figure(7)
%	plot(wT, unwrap(Phase))
 	 
